# -*- coding: iso-8859-1 -*-

#####################################################################
# Daniel Calderon S.
# CC3501
#####################################################################

# 01_Meteorito.py
# ---------------
# Dibuja un meteorito
# ---------------

# Implementacin testeada con:
## Python 2.6
## PyOpenGL 3.0.1
## PyGame 1.9.1

#####################################################################

# importar librera grfica
from OpenGL.GL import *
from OpenGL.GLU import *

# importar librera para manejar eventos
import pygame
from pygame.locals import *

from random import uniform

#####################################################################
# Funciones de inicializacin
#####################################################################

def init_pygame((w,h), title=""):
    pygame.init()
    pygame.display.set_mode((w,h), OPENGL|DOUBLEBUF)
    pygame.display.set_caption(title)
	
def init():
    glClearColor(0.0, 0.0, 0.0, 0.0)
    glClearDepth(1.0)
    glDisable(GL_DEPTH_TEST)
    glShadeModel(GL_SMOOTH)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST)
    glEnable (GL_BLEND)
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
    glHint (GL_LINE_SMOOTH_HINT, GL_NICEST)

def reshape((width, height)):
    if height == 0:
        height = 1
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluOrtho2D(0.0, width, 0.0, height)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
	
def init_opengl((w,h)):
    init()
    reshape((w,h))

#####################################################################

w=800 # ancho
h=600 # alto

# inicializando ...
init_pygame((w,h),"Titulo")
init_opengl((w,h))

run = True
while run:
    # 1: MANEJAMOS EVENTOS DE ENTRADA (TECLADO, MOUSE, ETC.)
    for event in pygame.event.get():
        if event.type == QUIT:
            run = False
        if event.type == KEYDOWN:
            if event.key == K_ESCAPE:
                run = False
				
    # 2: EJECUTAMOS LOGICA DE LA APLICACION
			
    # 3: DIBUJAMOS LOS ELEMENTOS
    glClear(GL_COLOR_BUFFER_BIT) # limpia la pantalla

    glBegin(GL_POLYGON)			# setea mtodo de dibujo
	
    glColor4f(1.0,1.0,1.0,1.0)	# asigna color al pincel
	
    rx = 100*uniform(0,1)
    ry = 100*uniform(0,1)
	
    glVertex2f(w/2-rx*143.0/150.0,h/2-ry*26.0/150.0)
    glVertex2f(w/2-rx*154.0/150.0,h/2+ry*86.0/150.0)
    glVertex2f(w/2-rx*66.0/150.0,h/2+ry*167.0/150.0)
    glVertex2f(w/2+rx*142.0/150.0,h/2+ry*110.0/150.0)
    glVertex2f(w/2+rx*175.0/150.0,h/2-ry*44.0/150.0)
    glVertex2f(w/2+rx*155.0/150.0,h/2-ry*108.0/150.0)
    glVertex2f(w/2+rx*53.0/150.0,h/2-ry*108.0/150.0)
    glVertex2f(w/2-rx*39.0/150.0,h/2-ry*149.0/150.0)
    glVertex2f(w/2-rx*162.0/150.0,h/2-ry*121.0/150.0)
			
    glEnd()    # fin del mtodo de dibujo
	
    # vuelca el dibujo a la pantalla
    pygame.display.flip()

#####################################################################